import json
from ai import call_AI
from summary import get_prompt_from_file
from utils import get_call_by_id


def compare_reports(report1, report2):
    prompt = get_prompt_from_file("compare_prompt.txt")
    return call_AI(prompt, report1, report2)


def create_compare(db, call_id_1, call_id_2):
    try:
        call1 = get_call_by_id(db, call_id_1)
        if not call1:
            print(f"Call with ID {call_id_1} not found.")
            return None

        json_transcript1 = call1.json_transcript
        if json_transcript1 is None:
            print(f"Transcript data missing for Call ID {call_id_1}.")
            return None

        if not isinstance(json_transcript1, str):
            try:
                json_transcript1 = json.dumps(json_transcript1, indent=2)
            except (TypeError, json.JSONDecodeError) as e:
                print(f"Error converting transcript to JSON for Call ID {call_id_1}: {e}")
                return None

        call2 = get_call_by_id(db, call_id_2)
        if not call2:
            print(f"Call with ID {call_id_2} not found.")
            return None

        json_transcript2 = call2.json_transcript
        if json_transcript2 is None:
            print(f"Transcript data missing for Call ID {call_id_2}.")
            return None

        if not isinstance(json_transcript2, str):
            try:
                json_transcript2 = json.dumps(json_transcript2, indent=2)
            except (TypeError, json.JSONDecodeError) as e:
                print(f"Error converting transcript to JSON for Call ID {call_id_2}: {e}")
                return None

        compare = generate_compare(json_transcript1, json_transcript2)

        if compare is None:
            print(f"Could not generate compare for Call ID {call_id_1} and {call_id_2}.")
            return None

        # Cleaning summary remains the same
        compare = compare.replace("```", "").strip()
        if compare.startswith("html"):
            compare = compare[4:].strip()

        #db.session.commit()
        print(f"Compare generated for Call ID {call_id_1} and {call_id_2}")  # Changed to info
        return compare

    except Exception as e:
        print(f"An unexpected error occurred during summary creation for Call ID {call_id_1} and {call_id_2}: {e}") # Changed to exception to log traceback
        #db.session.rollback()
        return None


def create_complete_prompt(prompt, transcript1, transcript2):
    """Creates a prompt with the transcript enclosed in a JSON code block."""
    return f"{prompt}```json Transcript1:\n{transcript1}\n Transcript2:\n{transcript2}\n```"


def generate_compare(json_transcript1, json_transcript2):
    """Generates a summary using the OpenAI API."""
    prompt = get_prompt_from_file("compare_prompt.txt")
    if prompt is None:
        return None  # Handle error from get_prompt_from_file

    complete_prompt = create_complete_prompt(prompt, json_transcript1, json_transcript2)
    try:
        compare = call_AI(complete_prompt) # Assuming Call_AI handles its own errors. This just returns.
        return compare
    except Exception as e:  # Catch potential exceptions during API call
        print(f"Error generating summary: {e}")
        return None